<?php 
use \yii\helpers\Html;
use \yii\helpers\Url;
use yii\widgets\DetailView;
use backend\models\User;
use backend\models\Tercero;
?>

<div class="row">
  <div class="col-md-12 col-lg-12 ftco-animate">
    <div class="blog-entry">
      

      <div class="text bg-white p-4">
        <?php
            if($model->imagen != '')
            {
                echo Html::img(Yii::$app->homeUrl.'admin/uploads/blog/md-'.$model->imagen, ['class' => 'block-inicio', 'style' => '']);   
            }              
        ?>


        <h3 class="heading" style="margin-top: 0px; line-height: 25px !important;"><a href="<?= Url::to(['site/view', 'id' => $model->id]) ?>"><?= $model->titulo ?></a></h3>

            <div class="meta" style="padding-bottom: 0px;">
                <a href="<?= Url::to(['site/blog', 'categoria' => $model->categoria]) ?>">
                  <span class="icon-tag text-info"></span> 
                    <?= $model->categorias->categoria ?>
                </a>
                  &nbsp;&nbsp;&nbsp;

                <span class="icon-calendar text-success"></span> 
                  <?= Yii::$app->formatter->asDate($model->creado_el, 'long');?>
                  &nbsp;&nbsp;&nbsp;
                <span class="icon-person text-primary"></span> 
                  <? 
                      
                      if($model->creado_por == 1)
                      {
                          echo "Sonic";
                      }
                      elseif($model->creado_por == '')
                      {
                          echo "Sin Definir";
                      }
                      else
                      {
                          $user = User::find()->where(['id' => $model->creado_por])->one();
                          $tercero = Tercero::find()->where(['identificacion' => $user->username])->one();  
                          echo $tercero->nombre;
                      }  
                      
                  ?>
                  &nbsp;&nbsp;&nbsp;
                <span class="icon-eye text-danger"></span> <?= $model->visto ?>
            </div>



        <p><?= $model->introduccion ?></p>
        
        <?php 
                    
          if($model->adjuntos != '' OR $model->contenido != '') 
          {

        ?>    
        <div class="d-flex align-items-center mt-4">
          <p class="mb-0"><a href="<?= Url::to(['site/view', 'id' => $model->id]) ?>" class="btn btn-primary">Leer Más <span class="ion-ios-arrow-round-forward"></span></a></p>

          <p class="ml-auto mb-0">
            
            <?php 
            
            if($model->adjuntos != '') 
            {
                $adjuntos = explode(',', $model->adjuntos); 
                $adjuntos_cantidad = count($adjuntos);
            ?>
                <span class="icon-attach_file"></span> <?=  ($adjuntos_cantidad > '1') ? $adjuntos_cantidad.' Archivos Adjuntos' : $adjuntos_cantidad.' Archivo Adjunto'?></span>
          
            <? } ?>
          </p>

        </div>

        <? } ?>

      </div>
    </div>
  </div>
</div>