<?php

use yii\helpers\Html;
use kartik\export\ExportMenu;
use yii\widgets\ListView; 
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $form yii\bootstrap\ActiveForm */
/* @var $model \frontend\models\ContactForm */

$this->title = 'Inicio';
//$this->params['breadcrumbs'][] = $this->title;

?>


<section class="ftco-section bg-light">
    <div class="container">
        <div class="row">
            <div class="col-md-8 col-lg-8 ftco-animate">
        <?= ListView::widget([
            'dataProvider' => $dataProvider,
            'itemOptions' => ['class' => 'item'],
            'layout' => "{items}\n{pager}",
            'itemView' => function ($model, $key, $index, $widget) {
                return $this->render('_index',['model' => $model, 'key' => $key, 'index' => $index, 'widget' => $widget, 'view' => $this]);
            },
        ]) ?> 
            </div>

            <div class="col-lg-4 sidebar ftco-animate">
                <!--
                <div class="sidebar-box">
                  <form action="#" class="search-form">
                    <div class="form-group">
                      <span class="icon icon-search"></span>
                      <input type="text" class="form-control" placeholder="Buscar...">
                    </div>
                  </form>
                </div>
                -->
                <div class="sidebar-box ftco-animate">
                  <h3>Categorías</h3>
                  <ul class="categories">
                    <?php
                        foreach ($categorias as $categoria) {
                          echo "<li>".html::a($categoria->categoria,['site/blog','categoria' => $categoria->id])."</li>";
                        }
                    ?>
                  </ul>
                </div>

                <div class="sidebar-box ftco-animate">
                  <h3>Artículos Populares</h3>

                  <?php
                        foreach ($populares as $popular) {    
                  ?>

                  <div class="block-21 mb-4 d-flex">
                    
                    <?php 
                      if($popular->imagen != '')
                      {
                        $imagen = Yii::$app->homeUrl."admin/uploads/blog/sm-".$popular->imagen;
                      }
                      else
                      {
                        $imagen = Yii::$app->homeUrl."admin/images/sonic_sm_blog.png";
                      } 
                    ?>  
                    

                    <a href="<?= Url::to(['site/view', 'id' => $popular->id]) ?>" class="blog-img mr-4" style="background-image: url(<?= $imagen ?>);"></a>
                    <div class="text">
                      <h3 class="heading" style="margin-top: 0px !important; margin-bottom: 0px !important; padding-bottom: 0px !important;">
                        <a href="<?= Url::to(['site/view', 'id' => $popular->id]) ?>"><?= $popular->titulo ?></a></h3>
                      <div class="meta" style="padding-bottom: 20px;">
                        <a href="<?= Url::to(['site/blog', 'categoria' => $popular->categoria]) ?>">
                          <span class="icon-tag text-info"></span> 
                            <?= $popular->categorias->categoria ?>
                        </a>
                            
                        &nbsp;&nbsp;&nbsp;
                        <span class="icon-calendar text-success"></span> 
                          <?= Yii::$app->formatter->asDate($popular->creado_el, 'short');?>
                          
                      </div>
                    </div>
                  </div>

                  <?php } ?>

                </div>

              <!--
                <div class="sidebar-box ftco-animate">
                  <h3>Paragraph</h3>
                  <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Ducimus itaque, autem necessitatibus voluptate quod mollitia delectus aut, sunt placeat nam vero culpa sapiente consectetur similique, inventore eos fugit cupiditate numquam!</p>
                </div>
               -->                               

              </div><!-- END COL -->
        </div>
    </div>
</section>