<?php

/* @var $this yii\web\View */

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Blog';
$this->params['breadcrumbs'][] = $this->title;

?>
<section class="ftco-section bg-light">
	<div class="container">
		<div class="row">
        

        <?php 
          
          if(count($model) == '0')
          {
              echo '<div class="col-md-12 col-lg-12 ftco-animate"><h5>No hay artículos en esta categoría</h5></div>';
          }
          else
          { 

            foreach ($model as $articulo) 
            { 
                if($categoria == '1')  ////  VISTA DEL BLOG DE INSTITUCIONAL
                {  
        ?>
            
          <div class="col-md-12 col-lg-12 ftco-animate">
            <div class="blog-entry">
              
              <div class="text bg-white p-4">
                
                <h3 class="heading"><a href="<?= Url::to(['site/view', 'id' => $articulo->id]) ?>"><?= $articulo->titulo ?></a></h3>
                <a href="<?= Url::to(['site/blog', 'categoria' => $articulo->categoria]) ?>">
                  <span class="label label-info"><?= $articulo->categorias->categoria ?></span>
                </a>

                <p><?= $articulo->introduccion ?></p>
                
                <div class="d-flex align-items-center mt-4">
	                
                  <?php 
                    
                    if($articulo->adjuntos != '' OR $articulo->contenido != '') 
                    {

                  ?>    
                      <p class="mb-0">
                        <a href="<?= Url::to(['site/view', 'id' => $articulo->id]) ?>" class="btn btn-primary">Leer Más <span class="ion-ios-arrow-round-forward"></span>
                        </a>
                      </p>
                  
                  <?php 
                    
                    }

                  ?> 
                  
                    
                    <?php 
                    
                    if($articulo->adjuntos != '') 
                    {
                        $adjuntos = explode(',', $articulo->adjuntos); 
                        $adjuntos_cantidad = count($adjuntos);
                    ?>
                      <p class="ml-auto mb-0">
                        <span class="icon-attach_file"></span> <?=  ($adjuntos_cantidad > '1') ? $adjuntos_cantidad.' Archivos Adjuntos' : $adjuntos_cantidad.' Archivo Adjunto'?></span>
                      </p>
                    <? } ?>
                  

                </div>
              </div>
            </div>
          </div>
          
        <? 
              }
              else   /////  VISTA DEL BLOG DE NOTICIAS
              {
                ?>
          <div class="col-md-6 col-lg-4 ftco-animate">
            <div class="blog-entry">
              <?php 
                if($articulo->imagen != '')
                {
                  $imagen = Yii::$app->homeUrl."admin/uploads/blog/md-".$articulo->imagen;
                }
                else
                {
                  $imagen = Yii::$app->homeUrl."admin/images/sonic_md_blog.png";
                } 
              ?> 
              <a href="<?= Url::to(['site/view', 'id' => $articulo->id]) ?>" class="block-20 d-flex align-items-end" style="background-image: url('<?= $imagen ?>');">
                <div class="meta-date text-center p-2">
                  <span class="day"><?= Yii::$app->formatter->asDate($articulo->creado_el, 'php:d');?></span>
                  <span class="mos"><?= substr(Yii::$app->formatter->asDate($articulo->creado_el, 'php:M'),0,3);?></span>
                  <span class="yr"><?= Yii::$app->formatter->asDate($articulo->creado_el, 'php:Y');?></span>
                </div>
              </a>
              <div class="text bg-white p-4">
                
                <h3 class="heading"><a href="<?= Url::to(['site/view', 'id' => $articulo->id]) ?>"><?= $articulo->titulo ?></a></h3>
                <a href="<?= Url::to(['site/blog', 'categoria' => $articulo->categoria]) ?>">
                  <span class="label label-info"><?= $articulo->categorias->categoria ?></span>
                </a>

                <p><?= $articulo->introduccion ?></p>
                
                <div class="d-flex align-items-center mt-4">
                  <p class="mb-0"><a href="<?= Url::to(['site/view', 'id' => $articulo->id]) ?>" class="btn btn-primary">Leer Más <span class="ion-ios-arrow-round-forward"></span></a></p>

                  <p class="ml-auto mb-0">
                    
                    <?php 
                    
                    if($articulo->adjuntos != '') 
                    {
                        $adjuntos = explode(',', $articulo->adjuntos); 
                        $adjuntos_cantidad = count($adjuntos);
                    ?>
                        <span class="icon-attach_file"></span> <?=  ($adjuntos_cantidad > '1') ? $adjuntos_cantidad.' Archivos Adjuntos' : $adjuntos_cantidad.' Archivo Adjunto'?></span>
                  
                    <? } ?>
                  </p>

                </div>
              </div>
            </div>
          </div>
                <?php
              }  
            } 
          } 
        ?>

        </div>
	</div>
</section>