<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\password\PasswordInput;


$this->title = 'Registro';
$this->params['breadcrumbs'][] = $this->title;
?>

<div style="clear:both;"></div>

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary">
            <i class="fas fa-angle-double-right"></i> <?= Html::encode($this->title) ?></h3>
    </div>

    <div class="panel-body" >
        <p>Por favor complete los siguientes campos para registrarse:</p>

        <?php
            $form = ActiveForm::begin([
                'validateOnSubmit' => true,
                'type' => ActiveForm::TYPE_VERTICAL,
                'options' => ['class' => 'main-task-form',
                              'id' => 'formulario',
                              'enctype'=>'multipart/form-data',
                            ]
            ]); 
        ?>

            <?= $form->errorSummary($model); ?>

        <div class="row">
            <div class="col-lg-6">
                <?= $form->field($model, 'username') ?>
            </div>
            <div class="col-lg-6">
                <?= $form->field($model, 'email') ?>
            </div>
            <div class="col-lg-6">
                <?= $form->field($model, 'password')->widget(PasswordInput::classname(), ['pluginOptions' => [
                        'verdictTitles' => [
                            0 => 'No Establecido',
                            1 => 'Muy Débil',
                            2 => 'Débil',
                            3 => 'Buena', 
                            4 => 'Fuerte',
                            5 => 'Muy Fuerte'
                        ],
                    ]]); ?>
            </div>
            <div class="col-lg-6">
                <div class="form-group">
                    <?= Html::submitButton(Yii::t('app', 'Registrarse'), ['class' => 'btn btn-primary', 'name' => 'signup-button']) ?>
                </div>
            </div>
            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>
