<?php
use yii\helpers\Html;
use backend\models\Sede;
use frontend\models\Matricula;
use backend\models\Acudiente;


$sede = Sede::find()->where(['principal' => '1'])->one();
$grupo = Matricula::find()->where(['estudiante' => $model->id])->one();

?>


<?= Html::img('@web/admin/images/header-pdf-1.png', ['class'=>'']); ?>

<h4 class="text-center" style="padding-top: 20px;"><b>CERTIFICA</b></h4>
<br>

<p class="text-justify" style="font-size:12px;">Que el estudiante <b><?= $model->nombre ?></b> <?= ($model->estado=='') ? '<span class="text-danger">no se encuentra Matriculado</span>' : 'se encuentra <span class="text-success"><b>'. $model->estados->estado .'</b></span>' ?> en grado <b><?= !$grupo ? '<span class="text-danger">Sin Asignar</span>' : '<span class="text-success">'.$grupo->grupos->grados->grado.'</span>' ?></b>, en el grupo <b><?= !$grupo ? '<span class="text-danger">Sin Asignar</span>' : '<span class="text-success">'.$grupo->grupos->grupo.'</span>' ?></b>, en la jornada <b><?= !$grupo ? '<span class="text-danger">Sin Asignar</span>' : '<span class="text-success">'.$grupo->grupos->jornadas->jornada.'</span>' ?></b> en la sede <b><?= !$grupo ? '<span class="text-danger">Sin Asignar</span>' : '<span class="text-success">'.$grupo->grupos->sedes->sede.'</span>' ?> para el año <span class="text-success"><b><?= $sede->vigencia ?></b></span>  con los siguientes datos.</p>

<br>


    <table style="font-size:10px; width:100%">
        <tr>
            <th width="20%">Nombres y Apellidos</th>
            <td width="30%"><?= $model->nombre ?></td>
            <th width="20%">Identificación</th>
            <td width="30%">
                <?= $model->identificacion ?>
                <?= $model->municipio_expedido ? $model->municipioexpedido->nombre : '' ?>
                <?= $model->departamento_expedido ? $model->departamentoexpedido->nombre : '' ?>
            </td>
        </tr>
        <tr>
            <th>Genero</th>
            <td><?= $model->generos->genero ?></td>
            <th>Fecha de Nacimiento</th>
            <td>
                <?= $model->fecha_nacimiento ?> 
                <?= $model->municipio_nacimiento ? $model->municipios->nombre : '' ?>
                <?= $model->departamento_nacimiento ? $model->departamentos->nombre : '' ?>
            </td>
        </tr>
        <tr>
            <th>Dirección</th>
            <td><?= $model->direccion ?></td>
            <th>Teléfono Celular</th>
            <td><?= $model->movil ?></td>
        </tr>
        <tr>
            <th>Teléfono Fijo</th>
            <td><?= $model->fijo ?></td>
            <th>E-Mail</th>
            <td><?= $model->email ?></td>
        </tr>
        <tr>
            <th>Grupo Sanguineo y RH</th>
            <td><?= ($model->rh =='') ? 'No Registrado' : $model->rhs->rh ?></td>
            <th>EPS</th>
            <td><?= ($model->eps =='') ? 'No Registrado' : $model->epss->eps ?></td>
        </tr>
        <tr>
            <th>Religión</th>
            <td><?= ($model->religion =='') ? 'No Registrado' : $model->religiones->religion ?></td>
            <th>Étnia</th>
            <td><?= ($model->etnia=='') ? 'No Registrado' : $model->etnias->etnia ?></td>
        </tr>
        <tr>
            <th>Resguardo</th>
            <td><?= ($model->resguardo=='') ? 'No Registrado' : $model->resguardos->resguardo .", ". $model->departamentos->nombre ?></td>
            <th>Estrato</th>
            <td><?= ($model->estrato =='') ? 'No Registrado' : $model->estratos->estrato ?></td>
        </tr> 
        <tr>
            <th>Estado Actual</th>
            <td><?= ($model->estado=='') ? 'No Registrado' : $model->estados->estado ?></td>
            <th>Fuente de Recurso</th>
            <td><?= ($model->recurso =='') ? 'No Registrado' : $model->recursos->tipo ?></td>
        </tr>
        <tr>
            <th>Sector Privado</th>
            <td><?= ($model->sector=='') ? 'No Registrado' : ($model->sector=='0' ) ? 'No' : 'Si' ?></td>
            <th>Subsidio</th>
            <td><?= ($model->subsidio=='') ? 'No Registrado' : ($model->subsidio=='0' ) ? 'No' : 'Si' ?></td>
        </tr>    
        <tr>
            <th>Cabeza de Familia</th>
            <td><?= ($model->cabeza_familia=='') ? 'No Registrado' : ($model->cabeza_familia=='0' ) ? 'No' : 'Si' ?></td>
            <th>Situación</th>
            <td><?= ($model->situacion =='') ? 'No Registrado' : $model->situaciones->tipo ?></td>
        </tr> 
        <tr>
            <th>Fuerza Pública</th>
            <td><?= ($model->fuerza_publica=='') ? 'No Registrado' : ($model->fuerza_publica=='0' ) ? 'No' : 'Si' ?></td>
            <th>Héroes Nacionales</th>
            <td><?= ($model->heroe=='') ? 'No Registrado' : ($model->heroe=='0' ) ? 'No' : 'Si' ?></td>
        </tr> 
        <tr>
            <th>Origen ICBF</th>
            <td><?= ($model->bienestar=='') ? 'No Registrado' : ($model->bienestar=='0' ) ? 'No' : 'Si' ?></td>
            <th>Nacionalidad</th>
            <td><?= ($model->pais=='') ? 'No Registrado' : $model->paises->pais ?></td>
        </tr> 
    </table>

<h6 class="text-primary" style="font-size:12px;">Información Médica<h6>

    <table style="font-size:10px;">
        <thead>
            <tr>
                <th width="50%">Tipo</th>
                <th width="50%">Descripción</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>Alergias</td>
                <td><?= $model->alergias == '' ? 'Ninguna' : $model->alergias ?></td>
            </tr>
            <tr>
                <td>Discapacidades</td>
                <td><?= $model->discapacidad  == '' ? 'Ninguna' : $model->discapacidad ?></td>
            </tr>
            <tr>
                <td>Discapacidad Certificada por EPS&nbsp;&nbsp;</td>
                <td><?= ($model->discapacidad_certificada=='') ? 'No Registrado' : ($model->discapacidad_certificada=='0' ) ? 'No' : 'Si' ?></td>
            </tr>
        </tbody>
    </table>


<h6 class="text-primary" style="font-size:12px;">Información de Familiares y Acudientes<h6>


<table style="font-size:10px; width:100%;">
  <thead>
    <tr>
        <th width="5%">#</th>
        <th width="40%">Nombres y Apellidos</th>
        <!--
        <th>Género</th>
        <th>Parentesco</th>
        <th>RH</th>-->
        <th width="15%">Fijo</th>
        <th width="15%">Celular</th>
        <th width="25%">Email</th>
    </tr>
  </thead>
  <tbody>

<?  
    $x = 1;
    foreach ($model->acudientes as $acudiente) { ?> 

      <tr>
        <th scope="row"><?= $x ?></th>
        <td><?= $acudiente->nombre ?></td>
        <!--
        <td><?= ($acudiente->genero =='') ? '' : $acudiente->generos->genero ?></td>
        <td><?= ($acudiente->parentesco =='') ? '' : $acudiente->parentescos->parentesco ?></td>
        <td><?= ($acudiente->rh =='') ? '' : $acudiente->rhs->rh ?></td> -->
        <td><?= $acudiente->fijo ?></td>
        <td><?= $acudiente->movil ?></td>
        <td><?= $acudiente->email ?></td>
      </tr>

<?  $x++; } ?>
  </tbody>
</table>
<br>
<br>

<p class="text-justify" style="font-size:10px;">Aceptamos planes y programas, Manuel de convivencia y demás normas complementarias del PEI y en constancia firmamos.</p>
<br>
<br>
<br>
<br>

<table border="0" style="font-size:10px; width:100%;">
    <tr>
        <td width="33%">________________________________________</td>
        <td width="33%">________________________________________</td>
        <td width="33%">________________________________________</td>
    </tr> 
    <tr>
        <td style="text-align: center;">Firma Estudiante</td>
        <td style="text-align: center;">Firma Acudiente</td>
        <td style="text-align: center;">Firma Rector(a)</td>
    </tr>    
</table>    
