<?php
use kartik\grid\GridView;
use yii\data\ArrayDataProvider;

    $dataProvider = new ArrayDataProvider([
        'allModels' => $model->academicos,
        'key' => 'id'
    ]);
    $gridColumns = [
        ['class' => 'yii\grid\SerialColumn'],
        [
                'attribute' => 'grupos.grupo',
                'label' => 'Grupo'
        ],
        'fecha_matricula',
        'fecha_retiro',
        [
            'attribute' => 'aprobo',
            'format' => 'RAW',
            'value' => function($model){
                return ($model->aprobo == '1') ? '<span class="label label-success">Si</span>' : '<span class="label label-danger">No</span>';
            },
            'filterType' => GridView::FILTER_SELECT2,
                'filter' => [0 => "No", 1 => "Si"],
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Aprobó', 'id' => 'grid-academico-search-aprobo']  
        ],
        [
            'class'=>'kartik\grid\BooleanColumn',
            'attribute'=>'estado', 
            'vAlign'=>'middle'
        ],        [
            'class' => 'yii\grid\ActionColumn',
            'controller' => 'academico'
        ],
    ];
    
    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => $gridColumns,
        'containerOptions' => ['style' => 'overflow: auto'],
        'pjax' => true,
        'beforeHeader' => [
            [
                'options' => ['class' => 'skip-export']
            ]
        ],
        'export' => [
            'fontAwesome' => true
        ],
        'bordered' => true,
        'striped' => true,
        'condensed' => true,
        'responsive' => true,
        'hover' => true,
        'showPageSummary' => false,
        'persistResize' => false,
    ]);
