<?php
use kartik\grid\GridView;
use yii\data\ArrayDataProvider;

    $dataProvider = new ArrayDataProvider([
        'allModels' => $model->asistencias,
        'key' => 'id'
    ]);
    $gridColumns = [
        ['class' => 'yii\grid\SerialColumn'],
        [
                'attribute' => 'grupos.grupo',
                'label' => 'Grupo',
                'group' => true,
        ],
        [
                'attribute' => 'periodos.periodo',
                'label' => 'Periodo',
                'group' => true,
        ],
        [
                'attribute' => 'asignaturas.asignatura',
                'label' => 'Asignatura',
                'group' => true,
        ],
        [
                'attribute' => 'docentes.nombre',
                'label' => 'Docente'
        ],
        'fallas',
        [
                'attribute' => 'tipoinasistencias.tipo_inasistencia',
                'label' => 'Tipo Inasistencia'
        ],
        'fecha',
        [
            'class' => 'yii\grid\ActionColumn',
            'controller' => 'asistencia'
        ],
    ];
    
    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => $gridColumns,
        'containerOptions' => ['style' => 'overflow: auto'],
        'pjax' => true,
        'beforeHeader' => [
            [
                'options' => ['class' => 'skip-export']
            ]
        ],
        'export' => [
            'fontAwesome' => true
        ],
        'bordered' => true,
        'striped' => true,
        'condensed' => true,
        'responsive' => true,
        'hover' => true,
        'showPageSummary' => false,
        'persistResize' => false,
    ]);
