<?php
use kartik\grid\GridView;
use yii\data\ArrayDataProvider;

    $dataProvider = new ArrayDataProvider([
        'allModels' => $model->director,
        'key' => 'id'
    ]);
    $gridColumns = [
        ['class' => 'yii\grid\SerialColumn'],
        [
                'attribute' => 'grados.grado',
                'label' => 'Grado'
        ],
        'grupo',
        [
                'attribute' => 'jornadas.jornada',
                'label' => 'Jornada'
        ],
        [
                'attribute' => 'sedes.sede',
                'label' => 'Sede'
        ],
        [
                'attribute' => 'metodologias.metodologia',
                'label' => 'Metodologia'
        ],
        [
                'attribute' => 'modalidades.modalidad',
                'label' => 'Modalidad'
        ],
        [
                'attribute' => 'especialidades.especialidad',
                'label' => 'Especialidad'
        ],
        'estado',
        [
            'class' => 'yii\grid\ActionColumn',
            'controller' => 'grupo'
        ],
    ];
    
    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => $gridColumns,
        'containerOptions' => ['style' => 'overflow: auto'],
        'pjax' => true,
        'beforeHeader' => [
            [
                'options' => ['class' => 'skip-export']
            ]
        ],
        'export' => [
            'fontAwesome' => true
        ],
        'bordered' => true,
        'striped' => true,
        'condensed' => true,
        'responsive' => true,
        'hover' => true,
        'showPageSummary' => false,
        'persistResize' => false,
    ]);
