<?php

use yii\helpers\Html;
use kartik\detail\DetailView;
use kartik\grid\GridView;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\helpers\Json;

use backend\models\base\Genero;
use backend\models\base\Departamento;
use backend\models\base\Municipio;
use backend\models\base\Tipodocumento;
use backend\models\base\Religion;
use backend\models\base\Etnia;
use backend\models\base\Rh;
use backend\models\base\Eps;
use backend\models\base\Barrio;
use backend\models\base\Tipotercero;
use backend\models\base\Parentesco;
use backend\models\base\Grupo;



    $color = "default";
    $estado = "";

    if ($model->tipo_tercero==1) $color="success";
    if ($model->tipo_tercero==2) $color="info";
    if ($model->tipo_tercero==3) $color="warning";
    if ($model->tipo_tercero==4) $color="danger"; 

    if ($model->tipo_tercero==1)
    {   
        $color_estado = "default";
        if ($model->estado==1) $color_estado="success";
        if ($model->estado==2) $color_estado="info";
        if ($model->estado==3) $color_estado="warning";
        if ($model->estado==4) $color_estado="danger"; 
        
        if (($model->estado==5) or ($model->estado==7) or ($model->estado==9)) $color_estado="success";
        if (($model->estado==6) or ($model->estado==8) or ($model->estado==10)) $color_estado="danger"; 

 
        $estado = '<span class="label label-'.$color_estado.'">';
        $estado .= !$model->estado ? 'No Definido' : $model->estados->estado;
        $estado .='</span>';
    }
        
    if ($model->grupoid == '0')
    {
        $grupo =($model->tipo_tercero==1) ? Html::a('<span class="label label-danger">Sin Grupo</span>',['/academico/create', 'id' => $model->id]) : ''; 
    }
    else
    {
        $data = Grupo::findOne($model->grupoid);
        $grupo ='<span class="label label-primary">Grupo '.$data->grupo.'</span>';
    } 

?>
<div class="container">

<div class="tercero-view">

    <div class="row">

        <div class="col-sm-8">
            <?= Html::img($model->foto ? '@web/uploads/thumbnail/sm-'.$model->foto : '@web/images/user.jpg', ['class'=>'foto img-circle img-responsive']); ?>
            <h4 class="tercero"><?= Html::encode($model->nombre) ?></h4>
        </div>
        <div class="col-sm-4">
            <?= "<h4 class='info-tercero'><span class='label label-{$color}'>".$model->tipoterceros->tipo."</span>&nbsp;&nbsp;".$estado."&nbsp;&nbsp;".$grupo."</h4>"; ?>
        </div>
    </div>

    <div class="row">
<?php 


    

    $gridColumn = [
        [
            'group'=>true,
            'label'=>'Información Básica',
            'rowOptions'=>['class'=>'titulo']
        ],
        [
            'columns' => [
                [
                    'attribute' => 'identificacion',
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
                [
                    'attribute'=>'tipo',
                    'value'=>$model->tipos->tipo,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Tipodocumento::find()->asArray()->all(), 'id', 'tipo'),
                    ],
                ],
                
            ],
        ], 

        [    
            'columns' => [
                [
                    'attribute'=>'genero',
                    'value'=>$model->generos->genero,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2,
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Genero::find()->asArray()->all(), 'id', 'genero'),
                    ],
                ], 
                [
                    'attribute' => 'tipo_tercero',
                    'label' => 'Tipo Tercero',
                    'format' => 'RAW',
                    'value' => "<span class='label label-{$color}'>".$model->tipoterceros->tipo."</span>&nbsp;&nbsp;".$estado."&nbsp;&nbsp;".$grupo,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2,
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Tipotercero::find()->asArray()->all(), 'id', 'tipo'),
                    ],
                ],           
                
            ],
        ],
        [    
            'columns' => [ 
                
                [
                    'attribute'=>'fecha_nacimiento', 
                    'format'=>'date',
                    'type'=>DetailView::INPUT_DATE,
                    'widgetOptions' => [
                        'pluginOptions'=>['autoclose' => true,
                                          'format' => 'yyyy-mm-dd',
                                          'todayHighlight' => true]
                    ],
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
                [
                    'attribute'=>'genero',
                    'value'=>$model->generos->genero,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2,
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Genero::find()->asArray()->all(), 'id', 'genero')],
                    'valueColOptions'=>['style'=>'width:30%']
                ],
            ],
        ], 

        [    
            'columns' => [
                [
                    'attribute'=>'departamento_nacimiento',
                    'value'=> $model->departamento_nacimiento ? $model->departamentos->nombre : '',
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Departamento::find()->asArray()->all(), 'id', 'nombre'),
                    ],
                ],   
                [
                    'attribute'=>'municipio_nacimiento',
                    'value'=> $model->municipio_nacimiento ? $model->municipios->nombre : '',
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Municipio::find()->asArray()->all(), 'id', 'nombre'),
                    ],
                ],
            ],
        ],        
        [
            'group'=>true,
            'label'=>'Información Adicional',
            'rowOptions'=>['class'=>'titulo']
        ],
        [    
            'columns' => [
                [
                    'attribute' => 'rh',
                    'value'=> $model->rh ? $model->rhs->rh : '',
                    'type'=>DetailView::INPUT_SELECT2,
                    'valueColOptions'=>['style'=>'width:30%'], 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Rh::find()->asArray()->all(), 'id', 'rh'),
                    ],
                ],    
                [
                    'attribute' => 'religion',
                    'label' => 'Religión',
                    'value' => $model->religion ? $model->religiones->religion : '',
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Religion::find()->asArray()->all(), 'id', 'religion'),
                    ],
                ],    
            ],
        ],
        [    
            'columns' => [
                [
                    'attribute' => 'etnia',
                    'value' => $model->etnia ? $model->etnias->etnia : '',
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Etnia::find()->asArray()->all(), 'id', 'etnia'),
                    ],
                ],
                [
                    'attribute' => 'eps',
                    'value' => $model->eps ? $model->epss->eps : '',
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Eps::find()->asArray()->all(), 'id', 'eps'),
                    ],
                ],
                
            ],
    ],    
    [
        'group'=>true,
        'label'=>'Información de Contácto',
        'rowOptions'=>['class'=>'titulo ']
    ],
    [    
            'columns' => [
                [
                    'attribute' => 'direccion',
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
                [
                    'attribute' => 'barrio',
                    'value' => $model->barrio ? $model->barrios->nombre : '',
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Barrio::find()->asArray()->all(), 'id', 'barrio'),
                    ],
                ],
            ],
    ], 
    [    
            'columns' => [
                [
                    'attribute' => 'fijo',
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
                [
                    'attribute' => 'movil',
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
                   
            ],
    ],
        [    
            'columns' => [
                'email:email', /*
                [
                    'attribute' => 'foto',
                    'valueColOptions'=>['style'=>'width:33%'],
                ],
                [
                    'attribute' => 'estado',
                    'valueColOptions'=>['style'=>'width:33%'],
                ],*/
            ],
    ],                  
 ];

    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn,
        'mode' => 'view',
        'enableEditMode' => false,
        'bordered' => true,
        'striped' => false,
        /*'panel' => [
            'heading' => '',
            'type' => DetailView::TYPE_SUCCESS,
        ],*/
        'condensed' => false,
        'responsive' => true,
        'hover' => true,
        'hAlign'=> 'center',
        'vAlign'=> 'center',
        'fadeDelay'=> '1000',
        'deleteOptions'=>[ // your ajax delete parameters
            //'params' => ['id' => 1000, 'kvdelete'=>true],
                'params' => ['custom_param'=>true],
                'url'=>['delete', 'id' => $model->id],
        ],
        'container' => ['id'=>'kv-demo'],
        'formOptions' => ['action' => Url::current(['#' => 'delete'])] // your action to delete
    ]);
?>
    </div>
</div>
</div>