<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\tercero */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Terceros', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="tercero-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Tercero'.' '. Html::encode($this->title) ?></h2>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        'identificacion',
        [
                'attribute' => 'tipos.tipo',
                'label' => 'Tipo'
        ],
        'primer_nombre',
        'segundo_nombre',
        'primer_apellido',
        'segundo_apellido',
        [
                'attribute' => 'generos.genero',
                'label' => 'Genero'
        ],
        [
                'attribute' => 'tipoTerceros.tipo',
                'label' => 'Tipo Tercero'
        ],

        'fecha_nacimiento',
        [
                'attribute' => 'departamentos.nombre',
                'label' => 'Departamento Nacimiento'
        ],
        [
                'attribute' => 'municipios.nombre',
                'label' => 'Municipio Nacimiento'
        ],
        [
                'attribute' => 'rh.rh',
                'label' => 'Rh'
        ],
        [
                'attribute' => 'religion.religion',
                'label' => 'Religion'
        ],
        [
                'attribute' => 'etnia.etnia',
                'label' => 'Etnia'
        ],
        [
                'attribute' => 'eps.eps',
                'label' => 'Eps'
        ],
        'direccion',
        [
                'attribute' => 'barrio.id',
                'label' => 'Barrio'
        ],
        'fijo',
        'movil',
        'email:email',
        'foto',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
    
    <div class="row">
<?php
    $gridColumnAcademico = [
        ['class' => 'yii\grid\SerialColumn'],
        [
                'attribute' => 'estudiantes.nombre',
                'label' => 'Estudiante'
        ],
        [
                'attribute' => 'grupos.grupo',
                'label' => 'Grupo'
        ],
        'fecha_matricula',
        'fecha_retiro',
        'aprobo',
        'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerAcademico,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-academico']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => Html::encode('Academico'.' '. $this->title),
        ],
        'columns' => $gridColumnAcademico
    ]);
?>
    </div>
    
    <div class="row">
<?php
    $gridColumnAsistencia = [
        ['class' => 'yii\grid\SerialColumn'],
        [
                'attribute' => 'asignatura.asignatura',
                'label' => 'Asignatura'
        ],
        [
                'attribute' => 'grupo.grupo',
                'label' => 'Grupo'
        ],
        [
                'attribute' => 'periodo.periodo',
                'label' => 'Periodo'
        ],
        [
                'attribute' => 'docentes.nombre',
                'label' => 'Docente'
        ],
        [
                'attribute' => 'estudiantes.nombre',
                'label' => 'Estudiante'
        ],
        'asistio',
        'fallas',
        [
                'attribute' => 'tipoInasistencias.tipo_inasistencia',
                'label' => 'Tipo Inasistencia'
        ],
        'fecha',
        'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerAsistencia,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-asistencia']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => Html::encode('Asistencia'.' '. $this->title),
        ],
        'columns' => $gridColumnAsistencia
    ]);
?>
    </div>
    
    <div class="row">
<?php
    $gridColumnCalificacion = [
        ['class' => 'yii\grid\SerialColumn'],
        'calificacion',
        [
                'attribute' => 'tercero.id',
                'label' => 'Docente'
        ],
        [
                'attribute' => 'tercero.id',
                'label' => 'Estudiante'
        ],
        [
                'attribute' => 'asignatura.asignatura',
                'label' => 'Asignatura'
        ],
        [
                'attribute' => 'grupo.grupo',
                'label' => 'Grupo'
        ],
        [
                'attribute' => 'periodo.periodo',
                'label' => 'Periodo'
        ],
        'nivelacion',
        'indicador',
        'observacion',
        'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerCalificacion,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-calificacion']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => Html::encode('Calificacion'.' '. $this->title),
        ],
        'columns' => $gridColumnCalificacion
    ]);
?>
    </div>
    
    <div class="row">
<?php
    $gridColumnGrupo = [
        ['class' => 'yii\grid\SerialColumn'],
        [
                'attribute' => 'grado.grado',
                'label' => 'Grado'
        ],
        'grupo',
        [
                'attribute' => 'tercero.id',
                'label' => 'Director'
        ],
        [
                'attribute' => 'jornada.jornada',
                'label' => 'Jornada'
        ],
        [
                'attribute' => 'sede.sede',
                'label' => 'Sede'
        ],
        'por_nota',
        [
                'attribute' => 'metodologia.metodologia',
                'label' => 'Metodologia'
        ],
        [
                'attribute' => 'modalidad.modalidad',
                'label' => 'Modalidad'
        ],
        [
                'attribute' => 'especialidad.especialidad',
                'label' => 'Especialidad'
        ],
        'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerGrupo,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-grupo']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => Html::encode('Grupo'.' '. $this->title),
        ],
        'columns' => $gridColumnGrupo
    ]);
?>
    </div>
</div>
