<?php

use yii\helpers\Html;
use yii\helpers\Url;
use kartik\widgets\ActiveForm;
use \yii\helpers\ArrayHelper;
use kartik\widgets\FileInput;




$this->title = 'Redactar';
$this->params['breadcrumbs'][] = ['label' => 'Mensajes', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Enviar', 'url' => false, 'action' => 'guardar', 'icon' => '<i class="far fa-envelope"></i>', 'class' => 'primary'];
$this->params['actions'][] = ['label' => 'Cancelar', 'url' => ['index'], 'icon' => '<i class="far fa-times"></i>', 'class' => 'danger'];


?>

<div class="row">
    <div class="col-lg-2">
		Archivos Adjuntos
    </div>
    
    <div class="col-lg-10">
	
		<div class="mail-box-header">
        	<h3>
            	Redactar Mensaje
        	</h3>
    	</div>
        <div class="mail-box">
        	<div class="mail-body">

			    <?php $form = ActiveForm::begin([
		            'validateOnSubmit' => true,
		            'type' => ActiveForm::TYPE_VERTICAL,
		            'options' => ['class' => 'form-horizontal',
		                          'id' => 'formulario',
		                          'enctype'=>'multipart/form-data',
		                        ]
		        ]); ?>	


			    <?= $form->errorSummary($model); ?>

	<div class="file-loading">
        <input id="input-705" name="kartik-input-705[]" type="file" accept="image/*" multiple>
    </div>
     
    <script>
	    $(document).ready(function() {
	    var $el1 = $("#input-705");
	    $el1.fileinput({
	        allowedFileExtensions: ['jpg', 'png', 'gif'],
	        uploadUrl: "/file-upload-batch/2",
	        uploadAsync: true,
	        deleteUrl: "/site/file-delete",
	        showUpload: false, // hide upload button
	        overwriteInitial: false, // append files to initial preview
	        minFileCount: 1,
	        maxFileCount: 5,
	        browseOnZoneClick: true,
	        initialPreviewAsData: true,
	    }).on("filebatchselected", function(event, files) {
	        $el1.fileinput("upload");
	    });
	    });
    </script>

				
				<div class="col-sm-12">

				    <?= $form->field($model, 'upload_file')->widget(FileInput::classname(), [
			            'options' => ['multiple'=>true],
			            'pluginOptions'=>[
			            	'uploadUrl' => Url::to(['/upload/upload']),
			            	
			                //'allowedFileExtensions'=>['jpg', 'gif', 'png', 'bmp','pdf','doc', 'docx','xls'],
			            	uploadAsync: true,
	        deleteUrl: "/site/file-delete",
	        showUpload: false, // hide upload button
	        overwriteInitial: false, // append files to initial preview
	        minFileCount: 1,
	        maxFileCount: 5,
	        browseOnZoneClick: true,
	        initialPreviewAsData: true,
			            	'previewFileType' => 'any',
			                'showUpload' => true,
			                'overwriteInitial' => false,
			                
			                ],
			        ])->label('Adjuntos:'); ?>
				
				</div>
			

			    <?php ActiveForm::end(); ?>
        	</div>
    	</div>
    </div>
</div>





