

CREATE TABLE `grupo_matricular` (
  `id` int(3) NOT NULL COMMENT 'Id',
  `sede_actual` int(2) NOT NULL COMMENT 'Sede',  
  `grado_actual` int(3) NOT NULL COMMENT 'Grado',
  `jornada_actual` int(3) NOT NULL COMMENT 'Jornada',
  `grupo_actual` int(3) NOT NULL COMMENT 'Grupo',
  `sede_nuevo` int(2) NOT NULL COMMENT 'Sede',  
  `grado_nuevo` int(3) NOT NULL COMMENT 'Grado',
  `jornada_nuevo` int(3) NOT NULL COMMENT 'Jornada',
  `grupo_nuevo` int(3) NOT NULL COMMENT 'Grupo',
  `creado_el` datetime DEFAULT NULL COMMENT 'Creado El',
  `creado_por` int(5) DEFAULT NULL COMMENT 'Creado Por',
  `actualizado_el` datetime DEFAULT NULL COMMENT 'Actualizado El',
  `actualizado_por` int(5) DEFAULT NULL COMMENT 'Actualizado Por',
  `eliminado_el` datetime DEFAULT NULL COMMENT 'Eliminado El',
  `eliminado_por` int(3) DEFAULT '0' COMMENT 'Eliminado Por',
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT 'Estado'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

ALTER TABLE `grupo_matricular`
  ADD PRIMARY KEY (`id`),
  ADD KEY `sede_actual` (`sede_actual`),
  ADD KEY `grado_actual` (`grado_actual`),
  ADD KEY `jornada_actual` (`jornada_actual`),
  ADD KEY `grupo_actual` (`grupo_actual`),
  ADD KEY `sede_nuevo` (`sede_nuevo`),
  ADD KEY `grado_nuevo` (`grado_nuevo`),
  ADD KEY `jornada_nuevo` (`jornada_nuevo`),
  ADD KEY `grupo_nuevo` (`grupo_nuevo`);

ALTER TABLE `grupo_matricular`
  MODIFY `id` int(3) NOT NULL AUTO_INCREMENT COMMENT 'Id', AUTO_INCREMENT=1;

ALTER TABLE `grupo_matricular`
  ADD CONSTRAINT `grupo_matricular_ibfk_1` FOREIGN KEY (`sede_actual`) REFERENCES `sede` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `grupo_matricular_ibfk_2` FOREIGN KEY (`grado_actual`) REFERENCES `grado` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `grupo_matricular_ibfk_3` FOREIGN KEY (`jornada_actual`) REFERENCES `jornada` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `grupo_matricular_ibfk_4` FOREIGN KEY (`grupo_actual`) REFERENCES `grupo` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `grupo_matricular_ibfk_5` FOREIGN KEY (`sede_nuevo`) REFERENCES `sede` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `grupo_matricular_ibfk_6` FOREIGN KEY (`grado_nuevo`) REFERENCES `grado` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `grupo_matricular_ibfk_7` FOREIGN KEY (`jornada_nuevo`) REFERENCES `jornada` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `grupo_matricular_ibfk_8` FOREIGN KEY (`grupo_nuevo`) REFERENCES `grupo` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;
  


create table academico_vigencia_anterior SELECT `id`,`estudiante`,`grupo`,`especialidad`,`fecha_matricula`,`aprobo`,`estado` FROM `academico` WHERE `eliminado_por`= 0; 

update `tercero` set estado=9 WHERE `tipo_tercero`=1 and estado =1; 

delete FROM `academico` WHERE 1

INSERT INTO academico(`id`, `estudiante`, `grupo`, `especialidad`, `fecha_matricula`, `creado_el`, `creado_por`, `actualizado_el`, `actualizado_por`, `eliminado_el`, `eliminado_por`,`estado`) SELECT `id`, `estudiante`, `grupo`, `especialidad`, `fecha_matricula`, `creado_el`, `creado_por`, `actualizado_el`, `actualizado_por`, `eliminado_el`, `eliminado_por`,`estado` FROM `matricula` WHERE 1;


UPDATE tercero set estado = 1 where id in (SELECT estudiante from academico where 1) and tipo_tercero=1;

ALTER DATABASE sonic_2023 CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
