CREATE TABLE `matricula` (
  `id` int(5) NOT NULL COMMENT 'Id',
  `estudiante` int(5) NOT NULL COMMENT 'Estudiante',
  `grupo` int(3) NOT NULL COMMENT 'Grupo',
  `especialidad` int(3) DEFAULT '1' COMMENT 'Especialidad',
  `fecha_matricula` date DEFAULT NULL COMMENT 'Fecha de Matricula',
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT 'Estado'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


ALTER TABLE `matricula`
  ADD PRIMARY KEY (`id`),
  ADD KEY `estudiante` (`estudiante`),
  ADD KEY `grupo` (`grupo`),
  ADD KEY `especialidad` (`especialidad`);


ALTER TABLE `matricula`
  MODIFY `id` int(5) NOT NULL AUTO_INCREMENT COMMENT 'Id', AUTO_INCREMENT=1;


ALTER TABLE `matricula`
  ADD CONSTRAINT `matricula_ibfk_1` FOREIGN KEY (`estudiante`) REFERENCES `tercero` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `matricula_ibfk_2` FOREIGN KEY (`grupo`) REFERENCES `grupo` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `matricula_ibfk_3` FOREIGN KEY (`especialidad`) REFERENCES `especialidad` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;
