ALTER TABLE `sede` ADD `sitio_online` INT(1) NOT NULL DEFAULT '1' COMMENT 'Sitio En Línea ' AFTER `activar_matriculas`, 
ADD `activar_pqrsd` INT(1) NOT NULL DEFAULT '1' COMMENT 'Sistema de PQRSD' AFTER `sitio_online`; 

CREATE TABLE `tipo_menu_web` (
  `id` int(3) NOT NULL COMMENT 'Id',
  `tipo` varchar(255) NOT NULL COMMENT 'Tipo de Menú'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


INSERT INTO `tipo_menu_web` (`id`, `tipo`) VALUES
(1, 'Categoría de Artículos'),
(2, 'Artículo'),
(3, 'Categoría de Documentos'),
(4, 'Documento'),
(5, 'Enlace');

ALTER TABLE `tipo_menu_web`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `tipo_menu_web`
  MODIFY `id` int(3) NOT NULL AUTO_INCREMENT COMMENT 'Id', AUTO_INCREMENT=6;

CREATE TABLE `menu_web` (
  `id` int(11) NOT NULL COMMENT 'Id',
  `tipo` int(3) NOT NULL  COMMENT 'Tipo Menú',
  `nombre` varchar(255) NOT NULL COMMENT 'Nombre',
  `alias` varchar(400) NOT NULL COMMENT 'Alias',
  `controlador` varchar(255) NOT NULL COMMENT 'Controlador',
  `item` varchar(255) DEFAULT NULL COMMENT 'Item',
  `padre` int(11) DEFAULT NULL COMMENT 'Padre',
  `orden` int(11) DEFAULT NULL COMMENT 'Orden',
  `creado_el` datetime DEFAULT NULL COMMENT 'Creado El',
  `creado_por` int(5) DEFAULT NULL COMMENT 'Creado Por',
  `actualizado_el` datetime DEFAULT NULL COMMENT 'Actualizado El',
  `actualizado_por` int(5) DEFAULT NULL COMMENT 'Actualizado Por',
  `eliminado_el` datetime DEFAULT NULL COMMENT 'Eliminado El',
  `eliminado_por` int(3) DEFAULT '0' COMMENT 'Eliminado Por',
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT 'Estado'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


ALTER TABLE `menu_web`
  ADD PRIMARY KEY (`id`),
  ADD KEY `padre` (`padre`),
  ADD KEY `tipo` (`tipo`);

ALTER TABLE `menu_web`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;


ALTER TABLE `menu_web`
  ADD CONSTRAINT `menu_web_ibfk_1` FOREIGN KEY (`padre`) REFERENCES `menu` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `menu_web_ibfk_2` FOREIGN KEY (`tipo`) REFERENCES `tipo_menu_web` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;