CREATE TABLE `promedio_area` (
  `id` int(5) NOT NULL COMMENT 'Id',
  `promedio_estudiante` varchar(10) DEFAULT NULL COMMENT 'Promedio Estudiante',
  `promedio_grupo` varchar(10) DEFAULT NULL COMMENT 'Promedio Grupo',
  `promedio_grado` varchar(10) DEFAULT NULL COMMENT 'Promedio Grado',
  `promedio_area` varchar(10) DEFAULT NULL COMMENT 'Promedio Área',
  `estudiante` int(3) NOT NULL COMMENT 'Estudiante',
  `grado` int(3) NOT NULL COMMENT 'Grado',
  `grupo` int(3) NOT NULL COMMENT 'Grupo',
  `periodo` int(1) NOT NULL COMMENT 'Periodo',
  `creado_el` datetime DEFAULT NULL COMMENT 'Creado El',
  `creado_por` int(5) DEFAULT NULL COMMENT 'Creado Por',
  `actualizado_el` datetime DEFAULT NULL COMMENT 'Actualizado El',
  `actualizado_por` int(5) DEFAULT NULL COMMENT 'Actualizado Por',
  `eliminado_el` datetime DEFAULT NULL COMMENT 'Eliminado El',
  `eliminado_por` int(3) DEFAULT '0' COMMENT 'Eliminado Por',
  `estado` int(1) NOT NULL DEFAULT '1' COMMENT 'Estado'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

ALTER TABLE `promedio_area`
  ADD PRIMARY KEY (`id`),
  ADD KEY `estudiante` (`estudiante`),
  ADD KEY `grado` (`grado`),
  ADD KEY `grupo` (`grupo`),
  ADD KEY `periodo` (`periodo`);

ALTER TABLE `promedio_area`
  MODIFY `id` int(5) NOT NULL AUTO_INCREMENT COMMENT 'Id', AUTO_INCREMENT=1;

ALTER TABLE `promedio_area`
  ADD CONSTRAINT `promedio_area_ibfk_1` FOREIGN KEY (`grado`) REFERENCES `grado` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `promedio_area_ibfk_2` FOREIGN KEY (`grupo`) REFERENCES `grupo` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `promedio_area_ibfk_3` FOREIGN KEY (`estudiante`) REFERENCES `tercero` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `promedio_area_ibfk_4` FOREIGN KEY (`periodo`) REFERENCES `periodo` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;
