/**
 * alertify
 * An unobtrusive customizable JavaScript notification system
 *
 * @author Fabien Doiron <fabien.doiron@gmail.com>
 * @copyright Fabien Doiron 2013
 * @license MIT <http://opensource.org/licenses/mit-license.php>
 * @link http://fabien-d.github.com/alertify.js/
 * @module alertify
 * @version 0.3.7
 */
(function(e,t){"use strict";var n=e.document,r;r=function(){var e={},r={},i=!1,s={ENTER:13,ESC:27,SPACE:32},o=[],u,a,f,l,c,h,p,d,v,m,g,y;return r={buttons:{holder:'<nav class="alertify-buttons">{{buttons}}</nav>',submit:'<button type="submit" class="alertify-button alertify-button-ok" id="alertify-ok">{{ok}}</button>',ok:'<a href="#" class="alertify-button alertify-button-ok" id="alertify-ok">{{ok}}</a>',cancel:'<a href="#" class="alertify-button alertify-button-cancel" id="alertify-cancel">{{cancel}}</a>'},input:'<div class="alertify-text-wrapper"><input type="text" class="alertify-text" id="alertify-text"></div>',message:'<p class="alertify-message">{{message}}</p>',log:'<article class="alertify-log{{class}}">{{message}}</article>'},y=function(){var e,r=n.createElement("fakeelement"),i={WebkitTransition:"webkitTransitionEnd",MozTransition:"transitionend",OTransition:"otransitionend",transition:"transitionend"};for(e in i)if(r.style[e]!==t)return i[e]},u=function(e){return n.getElementById(e)},e={labels:{ok:"OK",cancel:"Cancel"},delay:5e3,buttonReverse:!1,buttonFocus:"ok",transition:t,addListeners:function(e){var t=typeof f!="undefined",r=typeof a!="undefined",i=typeof g!="undefined",o="",u=this,c,h,p,d,v;c=function(t){return typeof t.preventDefault!="undefined"&&t.preventDefault(),p(t),typeof g!="undefined"&&(o=g.value),typeof e=="function"&&(typeof g!="undefined"?e(!0,o):e(!0)),!1},h=function(t){return typeof t.preventDefault!="undefined"&&t.preventDefault(),p(t),typeof e=="function"&&e(!1),!1},p=function(e){u.hide(),u.unbind(n.body,"keyup",d),u.unbind(l,"focus",v),i&&u.unbind(m,"submit",c),t&&u.unbind(f,"click",c),r&&u.unbind(a,"click",h)},d=function(e){var t=e.keyCode;t===s.SPACE&&!i&&c(e),t===s.ESC&&r&&h(e)},v=function(e){i?g.focus():r?a.focus():f.focus()},this.bind(l,"focus",v),t&&this.bind(f,"click",c),r&&this.bind(a,"click",h),this.bind(n.body,"keyup",d),i&&this.bind(m,"submit",c),typeof this.transition=="undefined"&&this.setFocus()},bind:function(e,t,n){typeof e.addEventListener=="function"?e.addEventListener(t,n,!1):e.attachEvent&&e.attachEvent("on"+t,n)},appendButtons:function(e,t){return this.buttonReverse?t+e:e+t},build:function(t){var n="",i=t.type,s=t.message,o=t.cssClass||"";n+='<div class="alertify-dialog">',e.buttonFocus==="none"&&(n+='<a href="#" id="alertify-noneFocus" class="alertify-hidden"></a>'),i==="prompt"&&(n+='<form id="alertify-form">'),n+='<article class="alertify-inner">',n+=r.message.replace("{{message}}",s),i==="prompt"&&(n+=r.input),n+=r.buttons.holder,n+="</article>",i==="prompt"&&(n+="</form>"),n+='<a id="alertify-resetFocus" class="alertify-resetFocus" href="#">Reset Focus</a>',n+="</div>";switch(i){case"confirm":n=n.replace("{{buttons}}",this.appendButtons(r.buttons.cancel,r.buttons.ok)),n=n.replace("{{ok}}",this.labels.ok).replace("{{cancel}}",this.labels.cancel);break;case"prompt":n=n.replace("{{buttons}}",this.appendButtons(r.buttons.cancel,r.buttons.submit)),n=n.replace("{{ok}}",this.labels.ok).replace("{{cancel}}",this.labels.cancel);break;case"alert":n=n.replace("{{buttons}}",r.buttons.ok),n=n.replace("{{ok}}",this.labels.ok);break;default:}return d.className="alertify alertify-show alertify-"+i+" "+o,p.className="alertify-cover",n},close:function(e,t){var n=t&&!isNaN(t)?+t:this.delay,r=this,i,s;this.bind(e,"click",function(){i(e)}),s=function(e){e.stopPropagation(),r.unbind(this,r.transition,s),v.removeChild(this),v.hasChildNodes()||(v.className+=" alertify-logs-hidden")},i=function(e){typeof e!="undefined"&&e.parentNode===v&&(typeof r.transition!="undefined"?(r.bind(e,r.transition,s),e.className+=" alertify-log-hide"):(v.removeChild(e),v.hasChildNodes()||(v.className+=" alertify-logs-hidden")))};if(t===0)return;setTimeout(function(){i(e)},n)},dialog:function(e,t,r,s,u){h=n.activeElement;var a=function(){if(d&&d.scrollTop!==null)return;a()};if(typeof e!="string")throw new Error("message must be a string");if(typeof t!="string")throw new Error("type must be a string");if(typeof r!="undefined"&&typeof r!="function")throw new Error("fn must be a function");return typeof this.init=="function"&&(this.init(),a()),o.push({type:t,message:e,callback:r,placeholder:s,cssClass:u}),i||this.setup(),this},extend:function(e){if(typeof e!="string")throw new Error("extend method must have exactly one paramter");return function(t,n){return this.log(t,e,n),this}},hide:function(){var e,t=this;o.splice(0,1),o.length>0?this.setup():(i=!1,e=function(n){n.stopPropagation(),d.className+=" alertify-isHidden",t.unbind(d,t.transition,e)},typeof this.transition!="undefined"?(this.bind(d,this.transition,e),d.className="alertify alertify-hide alertify-hidden"):d.className="alertify alertify-hide alertify-hidden alertify-isHidden",p.className="alertify-cover alertify-cover-hidden",h.focus())},init:function(){n.createElement("nav"),n.createElement("article"),n.createElement("section"),p=n.createElement("div"),p.setAttribute("id","alertify-cover"),p.className="alertify-cover alertify-cover-hidden",n.body.appendChild(p),d=n.createElement("section"),d.setAttribute("id","alertify"),d.className="alertify alertify-hidden",n.body.appendChild(d),v=n.createElement("section"),v.setAttribute("id","alertify-logs"),v.className="alertify-logs alertify-logs-hidden",n.body.appendChild(v),n.body.setAttribute("tabindex","0"),this.transition=y(),delete this.init},log:function(e,t,n){var r=function(){if(v&&v.scrollTop!==null)return;r()};return typeof this.init=="function"&&(this.init(),r()),v.className="alertify-logs",this.notify(e,t,n),this},notify:function(e,t,r){var i=n.createElement("article");i.className="alertify-log"+(typeof t=="string"&&t!==""?" alertify-log-"+t:""),i.innerHTML=e,v.insertBefore(i,v.firstChild),setTimeout(function(){i.className=i.className+" alertify-log-show"},50),this.close(i,r)},set:function(e){var t;if(typeof e!="object"&&e instanceof Array)throw new Error("args must be an object");for(t in e)e.hasOwnProperty(t)&&(this[t]=e[t])},setFocus:function(){g?(g.focus(),g.select()):c.focus()},setup:function(){var n=o[0],r=this,s;i=!0,s=function(e){e.stopPropagation(),r.setFocus(),r.unbind(d,r.transition,s)},typeof this.transition!="undefined"&&this.bind(d,this.transition,s),d.innerHTML=this.build(n),l=u("alertify-resetFocus"),f=u("alertify-ok")||t,a=u("alertify-cancel")||t,c=e.buttonFocus==="cancel"?a:e.buttonFocus==="none"?u("alertify-noneFocus"):f,g=u("alertify-text")||t,m=u("alertify-form")||t,typeof n.placeholder=="string"&&n.placeholder!==""&&(g.value=n.placeholder),this.addListeners(n.callback)},unbind:function(e,t,n){typeof e.removeEventListener=="function"?e.removeEventListener(t,n,!1):e.detachEvent&&e.detachEvent("on"+t,n)}},{alert:function(t,n,r){return e.dialog(t,"alert",n,"",r),this},confirm:function(t,n,r){return e.dialog(t,"confirm",n,"",r),this},extend:e.extend,init:e.init,log:function(t,n,r){return e.log(t,n,r),this},prompt:function(t,n,r,i){return e.dialog(t,"prompt",n,r,i),this},success:function(t,n){return e.log(t,"success",n),this},error:function(t,n){return e.log(t,"error",n),this},set:function(t){e.set(t)},labels:e.labels}},typeof define=="function"?define([],function(){return new r}):typeof e.alertify=="undefined"&&(e.alertify=new r)})(this);